--[[---------------------------------------------------------------------------
	Chocolatier Two Help
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local tabfont = { standardFontName, 13, DefaultColor }

MakeDialog
{
	name="help_dlg",
	Frame
	{
		x=kCenter,y=kCenter,w=640,h=440,color=DialogColor,
		AnimationWindow
		{
			x=5,y=5,w=kMax-5,h=kMax-5,fps=20,
			HelpTitle(10),
			Bitmap { x=0,y=1, image="control/recipe_up", scale=32/91},
			
			Window
			{
				x=kCenter,y=240, w=420,h=50, fit=true,
				Bitmap
				{
					x=0,y=0, w=48,h=32, fit=true,
					Bitmap { x=8,y=0, image="image/machine_square_small" },
					Text { x=0,y=32,w=48,h=bsgFontHeight(tabfont), label=LabelString("square"), font=tabfont, },
				},
				Bitmap
				{
					x=70,y=0, w=48,h=32, fit=true,
					Bitmap { x=8,y=0, image="image/machine_infusion_small" },
					Text { x=0,y=32,w=48,h=bsgFontHeight(tabfont), label=LabelString("infusion"), font=tabfont, },
				},
				Bitmap
				{
					x=140,y=0, w=48,h=32, fit=true,
					Bitmap { x=8,y=0, image="image/machine_sauce_small" },
					Text { x=0,y=32,w=48,h=bsgFontHeight(tabfont), label=LabelString("sauce"), font=tabfont, },
				},
				Bitmap
				{
					x=210,y=0, w=48,h=32, fit=true,
					Bitmap { x=8,y=0, image="image/machine_praline_small" },
					Text { x=0,y=32,w=48,h=bsgFontHeight(tabfont), label=LabelString("praline"), font=tabfont, },
				},
				Bitmap
				{
					x=280,y=0, w=48,h=32, fit=true,
					Bitmap { x=8,y=0, image="image/machine_truffle_small" },
					Text { x=0,y=32,w=48,h=bsgFontHeight(tabfont), label=LabelString("truffle"), font=tabfont, },
				},
				Bitmap
				{
					x=350,y=0, w=48,h=32, fit=true,
					Bitmap { x=8,y=0, image="image/machine_exotic_small" },
					Text { x=0,y=32,w=48,h=bsgFontHeight(tabfont), label=LabelString("exotic"), font=tabfont, },
				},
			},

			AppendStyle { font=helpFont, flags=kVAlignCenter+kHAlignLeft },
			Text { x=0,y=40,w=kMax,h=60, label="help10", flags=kVAlignTop+kHAlignLeft },

			Text { x=64,y=100,w=kMax,h=32, label="help10_unknown" },
			Bitmap { x=16,y=100, w=32,h=32, image="item/b_01",
				Bitmap { x=0,y=0,w=kCenter,h=kCenter, image="image/unknown_recipe_overlay" } },
			
			Text { x=64,y=140,w=kMax,h=32, label="help10_new" },
			Bitmap { x=16,y=140, w=32,h=32, image="item/b_01", },
			Sprite { x=32,y=154, image="glitz/sparkle.xml" },

			Text { x=64,y=180,w=kMax,h=32, label="help10_made" },
			Bitmap { x=14,y=180,w=36,h=36, image="item/highlight_infusion",
				Bitmap { x=kCenter,y=kCenter-2, image="item/i_01" } },

			Text { x=0,y=280,w=kMax,h=60, label="help10_tabs" },
			Text { x=0,y=340,w=kMax,h=60, label="help10_more" },
		}
	}
}
